#include "CameraCBuffer.hlsli"

Texture2D SourceTex : register(t0);

SamplerState PointSampler : register(s0);
SamplerState LinearSampler : register(s1);
SamplerState AnisoSampler : register(s2);

struct PSInput {
	float4 PositionViewportS : SV_Position;
	float2 TexCoords : TEXCOORD0;
};

float4 main(PSInput input) : SV_TARGET
{
	// Get the color at this pixel.
	float4 color = SourceTex.SampleLevel(LinearSampler, input.TexCoords, 0);

	// Alpha blend the current frame on top of the accumulated output
	color.a = LongExposureBlendFactor;

	return color;
}